﻿$(function () {
    debugger;
    //Define the Global Variables across functions.
    var bingMapsKey = 'AnMPbAuzGgURbEiN9H96j4mBiJo-JPk4fqMtkmfc6NEet28pqceuyiqk_kWrFD6x';
    var map, infobox, searchManager, orgUrl, webAPIUrl, searchLocation, userQueryId, fetchXmlEncoded;
    var specialtySearch = new String();
    var taxonomies = new Array();
  
    //We will load the map and other fucntions once the HTML page has finished loading. 
    document.onreadystatechange = function() {
        if (document.readyState == "complete") {
            startMap();
        }
    }

    function startMap() {
        
        // Load the map.
        map = new Microsoft.Maps.Map(document.getElementById('myMap'),
        {
            credentials: bingMapsKey,
            //center: new Microsoft.Maps.Location(38.890369, -77.031960),
            mapTypeId: Microsoft.Maps.MapTypeId.road,
            zoom: 12
        });
       
        // A setting for specifying the distance units displayed. Possible values are 'km' and 'mi'.
        var distanceUnits = 'mi';

        orgUrl = window.parent.Xrm.Page.context.getClientUrl();
        webAPIUrl = orgUrl + "/api/data/v8.2/";

        // Create a global infobox control.
        infobox = new Microsoft.Maps.Infobox(new Microsoft.Maps.Location(0, 0),
        {
            visible: false,
            offset: new Microsoft.Maps.Point(0, 20),
            height: 230,
            width: 230
        });

        infobox.setMap(map);

        // Create a session key from the map to use with data source service requests.
        var sessionKey;
        map.getCredentials(function (c) {
            sessionKey = c;
        });

        // Load the Search Module for Bing Maps for doing geocoding.
        Microsoft.Maps.loadModule('Microsoft.Maps.Search',
        {
            callback: function () {
                searchManager = new Microsoft.Maps.Search.SearchManager(map);
            }
        });

        Microsoft.Maps.loadModule('Microsoft.Maps.AutoSuggest', function () {
            var suggestOptions = {
                addressSuggestions: true,
                autoDetectLocation: true,
                placeSuggestions: true,
                maxResults: 4,
                map: map
            };
            var manager = new Microsoft.Maps.AutosuggestManager(suggestOptions);
            manager.attachAutosuggest('#searchBox', '#searchSuggestion');
        });

        // Resize the height of the results panel based on the available space.
        
        $(window).resize(function () {
            $('.resultsPanel').height($(window).height() - $('.searchBar').height() - 360);
            $('.mapPanel').height($(window).height() - 360);
            $('.sidePanel').height($(window).height() - 360);
        });
        $(window).resize();
        

        // A simple function for displaying error messages in the app.
        function showErrorMsg(msg) {
            $('.resultsPanel').html('<span class="errorMsg">' + msg + '</span>');
        }

        // A simple function for clearing the map and results panel.
        function clearMapAndResultsPanel() {

            for (var i = map.entities.getLength() - 1; i >= 0; i--) {
                var pushpin = map.entities.get(i);
                if (pushpin instanceof Microsoft.Maps.Pushpin) {
                    map.entities.removeAt(i);
                }
            }
            infobox.setOptions({ visible: false });
            $('.resultsPanel').html('');
            document.getElementById('loaderTitle').style.display = 'none';
            document.getElementById('loader').style.display = 'none';
            document.getElementById('resultsPanel').style.display = 'none';
        }

        // Formats a time in 1000 hours to hh:mm AM/PM format
        function formatTime(val) {
            var minutes = val % 100;
            var hours = Math.round(val / 100);

            if (minutes == 0) {
                minutes = '00';
            }

            if (hours > 12) {
                return (hours - 12) + ':' + minutes + 'PM';
            } else {
                return hours + ':' + minutes + 'AM';
            }
        }

        // Calculates the shortest distance between two locations on the curvature of the earth.
        function haversineDistance(loc1, loc2) {
            var degToRad = Math.PI / 180,
                lat1 = loc1.latitude * degToRad,
                lon1 = loc1.longitude * degToRad,
                lat2 = loc2.latitude * degToRad,
                lon2 = loc2.longitude * degToRad;

            var dLat = lat2 - lat1,
                dLon = lon2 - lon1,
                cordLength = Math.pow(Math.sin(dLat / 2), 2) +
                    Math.cos(lat1) * Math.cos(lat2) * Math.pow(Math.sin(dLon / 2), 2),
                centralAngle = 2 * Math.atan2(Math.sqrt(cordLength), Math.sqrt(1 - cordLength));

            var earthRadius = (distanceUnits == 'km') ? 6378.1 : 3963.1676;
            var distance = earthRadius * centralAngle;

            // Round off distance to 2 decimal place
            return Math.round(distance * 100) / 100;
        }

        // Add a key press event to the search box that triggers the search when the user presses Enter key.
        $('#specialtySearchBox').keypress(function (e) {
            if (e.which == 13) {
                $('#specialtySearchButton').click();
            }
        });

        // Add a click event to the search button.
        $('#specialtySearchButton').click(function () {
            //$('#specialtySearchBox')[0].value = "";
            specialtySearch = $('#specialtySearchBox')[0].value;
            taxonomies = [];
            var objectTypeCode = "";
            if (Mscrm.XrmInternal.getEntityCode != null && Mscrm.XrmInternal.getEntityCode != undefined)
                objectTypeCode = Mscrm.XrmInternal.getEntityCode("ppms_taxonomy");
            else
                objectTypeCode = Mscrm.XrmInternal.prototype.getEntityCode("ppms_taxonomy");

            var DialogOptions = new window.parent.Xrm.DialogOptions();
            DialogOptions.width = 800;
            DialogOptions.height = 600;

            var url = orgUrl + "/_controls/lookup/lookupmulti.aspx?class=null&objecttypes=" + objectTypeCode + "&browse=0&ShowNewButton=0&ShowPropButton=1&DefaultType=0" + "&search=" + specialtySearch;

            window.parent.Xrm.Internal.openDialog(url, DialogOptions, null, null, CallbackFunction);

            function CallbackFunction(event) {
                if (event.items.length != 0) {
                    var specialties = event.items;
                    var name = new String();
                    for (var s = 0; s < specialties.length; s++) {
                        name += event.items[s].name;
                        var taxonomyId = event.items[s].id.replace(/[{}]/g, "");
                        taxonomies.push(taxonomyId);
                        if (s != specialties.length - 1) { name += ", " };
                    }
                    $('#specialtySearchBox')[0].value = name;
                    specialtySearch = $('#specialtySearchBox')[0].value;
                }
            }
        });

        // Add a key press event to the search box that triggers the search when the user presses Enter key.
        $('#searchBox').keypress(function (e) {
            if (e.which == 13) {
                $('#searchBtn').click();
            }
        });
        
        // Add a click event to the search button.
        $('#searchBtn').click(function () {
            clearMapAndResultsPanel();
            document.getElementById('loaderTitle').style.display = 'block';
            document.getElementById('loader').style.display = 'block';
            //Filtering Options
            //Each time the Search Button is clicked we will recheck the Criteria selected by user.           
            var checkboxes = document.getElementsByName('checkbox');
            //Check for a value in the the Specialty Search box. 
            specialtySearch = $('#specialtySearchBox')[0].value;

            //Build the FetchXml here for the savedview. 
            var fetchXml = new String();
            fetchXml =
                '<fetch version="1.0" output-format="xml-platform" mapping="logical" distinct="true">' +
                '<entity name="account">' +
                '<attribute name="name"/>' +
                '<attribute name="ppms_providertype" />'+
                '<attribute name="ppms_npiid" />' +
                '<attribute name="address1_stateorprovince" />' +
                '<attribute name="address1_longitude" />' +
                '<attribute name="address1_latitude" />' +
                '<attribute name="address1_city" />' +
                '<attribute name="address1_line1" />' +
                '<attribute name="modifiedon" />' +
                '<attribute name="address1_postalcode" />' +
                '<attribute name="ppms_gender" />' +
                '<attribute name="ppms_affiliationtype_triwest" />' +
                '<attribute name="ppms_primarycareprovideracceptingva" />' +
                '<attribute name="ppms_primarycarephysician" />' +
                '<attribute name="ppms_individualisacceptingnewpatients" />' +
                '<attribute name="ppms_affiliationtype_healthnet" />' +
                '<attribute name="address1_country" />' +
                '<attribute name="accountid" />' +
                //'<link-entity name="ppms_providertaxonomy" alias="ppms_providertaxonomy" to="accountid" from="ppms_providerid" link-type="outer">' +
                //    '<attribute name="ppms_name"/>'+
                //'</link-entity>'+
                '<order attribute="name" descending="false" />' +
                '<filter type="and">' +
                '<condition attribute="statecode" operator="eq" value="0" />' +
                '<condition attribute="ppms_providerstatus" operator="eq" value="767940000" />' +
                '<condition attribute="ppms_providertype" operator="eq" value="767940000" />' +
                '<condition attribute="address1_line1" operator="not-null" />' +
                '<condition attribute="address1_city" operator="not-null" />' +
                '<condition attribute="address1_stateorprovince" operator="not-null" />' +
                '<condition attribute="address1_postalcode" operator="not-null" />' +
                '<condition attribute="ppms_geocoded" operator="eq" value="1" />';
            //If both Healthnet / Triwest are checked, we will treate it as an OR filter. 
            if (checkboxes[0].checked && checkboxes[1].checked) {
                fetchXml +=
                    '<filter type="or">' +
                    '<condition attribute="ppms_affiliationtype_healthnet" operator="eq" value="1" />' +
                    '<condition attribute="ppms_affiliationtype_triwest" operator="eq" value="1" />' +
                    '</filter>';
            }
            //If only one is checked, then we just add that one to the list of condition filters
            if (!checkboxes[0].checked || !checkboxes[1].checked) {
                if (checkboxes[0].checked) { fetchXml += '<condition attribute="ppms_affiliationtype_healthnet" operator="eq" value="1" />' }
                if (checkboxes[1].checked) { fetchXml += '<condition attribute="ppms_affiliationtype_triwest" operator="eq" value="1" />' }
            };
            //Check Gender if one of the genders is unchecked, we will search based on the selected gender. 
            if (!checkboxes[2].checked || !checkboxes[3].checked) {
                if (checkboxes[2].checked) { fetchXml += '<condition attribute="ppms_gender" operator="eq" value="767940002" />'}
                if (checkboxes[3].checked) { fetchXml += '<condition attribute="ppms_gender" operator="eq" value="767940001" />'}                  
            };
            //Check if Primary Care Physician
            if (checkboxes[4].checked) { fetchXml += '<condition attribute="ppms_primarycarephysician" operator="eq" value="1" />'};
            //Check for Accepting New Patients
            if (checkboxes[5].checked) { fetchXml += '<condition attribute="ppms_individualisacceptingnewpatients" operator="eq" value="1" />'};
            //Check Primary Care is accepting VA 
            if (checkboxes[5].checked) { fetchXml += '<condition attribute="ppms_primarycareprovideracceptingva" operator="eq" value="1" />'};
            fetchXml += '</filter>';
        if (!!specialtySearch && !!taxonomies) {
            fetchXml +=
                '<link-entity name="ppms_providertaxonomy" from="ppms_providerid" to="accountid" alias="aa"><filter type="and">';
                if (taxonomies.length >1) {fetchXml += '<filter type="or">'};
                for (var t = 0; t < taxonomies.length; t++) {
                    var taxonomyId = taxonomies[t];
                    fetchXml +=
                        '<condition attribute="ppms_taxonomyid" operator="eq" uiname="" uitype="ppms_taxonomy" value="{' + taxonomyId + '}" />';
                };
                if (taxonomies.length > 1) { fetchXml += '</filter>'};
                fetchXml +=  '</filter></link-entity>';
        };
            fetchXml += '</entity></fetch>';

            fetchXmlEncoded = escape(fetchXml);

            geocodeRequest();
        //Not going to Save and use a User Query for now, but may come in use later..
            /*
        var userQuery = JSON.stringify({
            "name": "User Defined Provider Query",
            "description": "User Defined Provider Query from Options Selected.",
            "returnedtypecode": "account",
            "fetchxml": fetchXml,
            "querytype": 0
        });                               
        $.ajax({
            type: "POST",
            contentType: "application/json; charset=utf-8",
            datatype: "json",
            url: webAPIUrl + "userqueries",
            data: userQuery,
            beforeSend: function(XMLHttpRequest) {
                //Specifying this header ensures that the results will be returned as JSON.             
                XMLHttpRequest.setRequestHeader("Accept", "application/json");
            },
            success: function(data, textStatus, xhr) {
                //var userQueryIdUrl = xhr.getResponseHeader("Odata-EntityId");
                var parseQuery = /\(([^)]+)\)/;
                var queryMatches = parseQuery.exec(xhr.getResponseHeader("Odata-EntityId"));
                userQueryId = queryMatches[1];
                geocodeRequest();
            },
            error: function(e) {
                showErrorMsg('Unable to generate Query');
            }
        });
        */
            function geocodeRequest() {
                // Create a request to geocode the users search.
                var geocodeRequest = {
                    where: $('#searchBox').val(),
                    count: 1,
                    callback: function(r) {
                        if (r &&
                            r.results &&
                            r.results.length > 0 &&
                            r.results[0].location) {
                            searchLocation = r.results[0].location;
                            findProviders();
                        } else {
                            document.getElementById('loaderTitle').style.display = 'none';
                            document.getElementById('loader').style.display = 'none';                            
                            document.getElementById('resultsPanel').style.display = 'block';
                            showErrorMsg('Unable to geocode query');
                        }
                    },
                    errorCallback: function () {
                        document.getElementById('loaderTitle').style.display = 'none';
                        document.getElementById('loader').style.display = 'none';                       
                        document.getElementById('resultsPanel').style.display = 'block';
                        showErrorMsg('Unable to geocode query');
                    }
                };

                // Geocode the users search.
                searchManager.geocode(geocodeRequest);
            }
        });

       
        function findProviders() {
           
            //Generate a Request URL with options to Query CRM Web API data. 
            var number = 25;
            var request = new String();

            //var requestType = "accounts?userQuery=";
            //request += webAPIUrl + requestType + userQueryId;

            var requestType = "accounts?fetchXml=";
            request += webAPIUrl + requestType + fetchXmlEncoded;
            
            $.ajax({
                type: "GET",
                contentType: "application/json; charset=utf-8",
                datatype: "json",
                url: request,
                beforeSend: function (XMLHttpRequest) {
                    //Specifying this header ensures that the results will be returned as JSON.             
                    XMLHttpRequest.setRequestHeader("Accept", "application/json");
                },
                success: function (data, textStatus, xhr) {                   
                    filterProviders(data, textStatus, xhr);
                    //Only doing this if we ended up Creating a User Query. 
                    //cleanUpUserQuery();
                },
                error: function (e) {
                    document.getElementById('loaderTitle').style.display = 'none';
                    document.getElementById('loader').style.display = 'none';                    
                    document.getElementById('resultsPanel').style.display = 'block';
                    showErrorMsg(e.statusText);
                }
            });
        }

        function cleanUpUserQuery() {
            
            //Delete the userquery that was created. 
            $.ajax({
                type: "DELETE",
                contentType: "application/json; charset=utf-8",
                datatype: "json",
                url: webAPIUrl + "userqueries("+userQueryId+")",
                beforeSend: function (XMLHttpRequest) {
                    //Specifying this header ensures that the results will be returned as JSON.             
                    XMLHttpRequest.setRequestHeader("Accept", "application/json");
                },
                success: function (data, textStatus, xhr) {
                },
                error: function (e) {
                    var error = e;
                }
            });

        }

        function filterProviders(data, textStatus, xhr) {
            var providers = data.value;
            //IF after applying the filters we have Providers, proceed to sorting by distance / radius. 
            //Otherwise display a message to the user. 
            if (providers.length > 0) {
                sortProvidersByDistance(providers);
            } else {
                document.getElementById('loaderTitle').style.display = 'none';
                document.getElementById('loader').style.display = 'none';                
                document.getElementById('resultsPanel').style.display = 'block';
                showErrorMsg('No Providers found matching the Search Criteria. Try updating your Search Criteria or Expand your Search Radius.');
            }                                    
        }

        function sortProvidersByDistance(providers) {

            //Filter out the Providers outside of the defined Radius.
            var searchRadius = $('#radiusSelection').find(":selected").val();
            var providersInRadius = providers.filter(function (provider) {
                var distance = haversineDistance(searchLocation,
                    new Microsoft.Maps
                    .Location(provider.address1_latitude, provider.address1_longitude));
                provider.distance = distance;
                return (distance <= searchRadius)
            });

            if (providersInRadius.length > 0) {

                //Sort the New Provider Array by the distance. 
                providersInRadius.sort(function(a, b) { return a['distance'] - b['distance'] });

                //The Routes Calculation can take at most 25 WayPoints. The way its calculated 12  provider locations + 12x search loacation. 
                providersInRadius = providersInRadius.slice(0, 12);

                //Define the Route Request URL.
                var distanceUnits = 'mi';
                var wayPoint1Latitude = searchLocation.latitude;
                var wayPoint1Longitude = searchLocation.longitude;
                var wayPoint1 = wayPoint1Latitude + ", " + wayPoint1Longitude;
                var routeRequest = 'https://dev.virtualearth.net/REST/V1/Routes/Driving?'
                var wayPointNum = 0;
                for (var p = 0; p < providersInRadius.length; p++) {
                    routeRequest += '&wp.' + wayPointNum + '=' + encodeURIComponent(wayPoint1);
                    wayPointNum += 1;
                    var wayPointLatitude = providersInRadius[p].address1_latitude;
                    var wayPointLongitude = providersInRadius[p].address1_longitude;
                    var wayPoint = wayPointLatitude + ", " + wayPointLongitude;
                    routeRequest += '&wp.' + wayPointNum + '=' + encodeURIComponent(wayPoint);
                    wayPointNum += 1;
                }
                routeRequest +=
                    '&avoid=minimizeTolls&du=' +
                    encodeURIComponent(distanceUnits) +
                    '&key=' +
                    encodeURIComponent(bingMapsKey);

                CallRouteService(routeRequest,
                    providersInRadius,
                    drivingResultsCallback);
            } else {
                document.getElementById('loaderTitle').style.display = 'none';
                document.getElementById('loader').style.display = 'none';
                document.getElementById('resultsPanel').style.display = 'block';
                showErrorMsg('No Providers found matching the Search Criteria. Try updating your Search Criteria or Expand your Search Radius.');
            }
        }

        function CallRouteService(routeRequest, providersInRadius, callback) {
            $.ajax({
                url: routeRequest,
                dataType: "jsonp",
                jsonp: "jsonp",
                success: function (r) {
                    callback(r, providersInRadius);
                },
                error: function (e) {
                    //alert(e.statusText);
                    alert("Driving Route Error: " + e.statusText)
                }
            });
        }

        function drivingResultsCallback(routeResult, providersInRadius) {
            // Do something with the result
            if (routeResult &&
                routeResult.resourceSets &&
                routeResult.resourceSets.length > 0 &&
                routeResult.resourceSets[0].resources &&
                routeResult.resourceSets[0].resources.length > 0) {
                var travelDistanceSet = routeResult.resourceSets[0];
                var routeLegs = travelDistanceSet.resources[0].routeLegs;
                var routes = new Array();
                for (var r = 0; r < routeLegs.length; r++) {
                    //Only add the Even Route Results to the Routes. 
                    if ((r & 1) == 0) {
                        var routeDrivingDistance = routeLegs[r].travelDistance;
                        routeDrivingDistance = Math.round(routeDrivingDistance * 100) / 100;
                        routes.push(routeDrivingDistance);
                    } 
                }
                var providerDrivingDistances = new Array();
                for (var p = 0; p < providersInRadius.length; p++) {
                    providersInRadius[p].drivingDistance = routes[p];
                    providerDrivingDistances.push(providersInRadius[p]);
                }
                //Sorth the New Provider Array by the distance. 
                providerDrivingDistances.sort(function (a, b) { return a['drivingDistance'] - b["drivingDistance"] });
                AddProvidersToMap(providerDrivingDistances);
            }
        }


        function AddProvidersToMap(providerDrivingDistances) {

            //Create an array to store the Provider info passed into function. 
            var providers = providerDrivingDistances;
            //Create an array to store the location metadata. 
            var locs = [];
            // Create an array to store the HTML used to generate the list of results.
            var listItems = [];
            //Get the actual address entered in Searchbox for generating directions. The Geocoded searchLocation give's coordinates,
            //which do not work well passed into the Bing Directions URL. 
            var veteranLocation = $('#searchBox').val();

            document.getElementById('loaderTitle').style.display = 'none';
            document.getElementById('loader').style.display = 'none';           
            document.getElementById('resultsPanel').style.display = 'block';
            // Create the HTML for a single list item for the result.                        
            //listItems.push('<table class="listItem"><tr><th>Provider Details</th><th>Directions & Distance</th></tr><tr><td rowspan="1"></td>');
            listItems.push('<table class="listItem"><th>Provider Details</th><th>Directions & Distance</th>');

            //Loop through the Providers and add them to the map. 
            for (var p = 0; p < providers.length; p++) {
                //Define the Provider's Location for the map. 
                var loc = new Microsoft.Maps
                    .Location(providers[p].address1_latitude, providers[p].address1_longitude);
                // Add the location coordinate to the array of locations
                locs.push(loc);
                // Create pushpin
                var pin = new Microsoft.Maps.Pushpin(loc,
                    {
                        icon: null,
                        text: (locs.length) + ''
                    }
                );
                // Store the location result info as a property of the pushpin so we can use it later.
                pin.Metadata = providers[p];
                // Add a click event to the pushpin to display an infobox.
                Microsoft.Maps.Events.addHandler(pin,
                    'click',
                    function(e) {
                        displayInfobox(e.target);
                    });
                // Add the pushpin to the map.
                map.entities.push(pin);

                listItems.push('<table class="listItem">');
                // Store the result ID as a property of the name. This will allow us to relate the list item to the pushpin on the map.
                listItems
                    .push('<td colspan="3"><a class="title" href="javascript:void(0);" rel="',
                        providers[p].accountid,
                        '">',
                        (locs.length) + ". " + providers[p].name,
                        '</a><br/>' +
                        providers[p].address1_line1,
                        '<br/>',
                        providers[p].address1_city,
                        ', ');
                        listItems.push(providers[p].address1_stateorprovince,
                            ' ',
                            providers[p].address1_postalcode,
                        '<br/>',
                        '<a class="viewprofile" href="javascript:void(0);" rel="',
                        providers[p].accountid,
                        '">',
                        "View Profile",
                        '</a></td>');
                listItems
                    .push('<td colspan="2"><a target="_blank" href="https://bing.com/maps/default.aspx?rtp=adr.',
                        veteranLocation,
                        '~pos.',
                        pin.Metadata.address1_latitude,
                        '_',
                        pin.Metadata.address1_longitude,
                        '_',
                        encodeURIComponent(pin.Metadata.name),
                        '">Directions</a> <br/>' +
                        providers[p].drivingDistance, ' ', distanceUnits,
                        '</td>');

                listItems.push('</table>');
            }

            // Use the array of locations from the results to set the map view to show all locations.
            if (locs.length > 1) {
                map
                    .setView({
                        bounds: Microsoft.Maps.LocationRect.fromLocations(locs),
                        padding: 80
                    });
            } else {
                map.setView({ center: locs[0], zoom: 15 });
            }

            // Add the list items to the results panel.
            $('.resultsPanel').html(listItems.join(''));

            // Add a click event to the title of each list item.
            $('.title').click(function() {
                // Get the ID of the selected location
                var id = $(this).attr('rel');
                //Loop through all the pins in the data layer and find the pushpin for the location.
                var pin;
                for (var i = 0; i < map.entities.getLength(); i++) {
                    pin = map.entities.get(i)
                    if (pin.Metadata.accountid != id) {
                        pin = null;
                    } else {
                        break;
                    }
                }
                // If a pin is found with a matching ID, then center the map on it and show it's infobox.
                if (pin) {
                    // Offset the centering to account for the infobox.
                    map.setView({
                        center: pin.getLocation(),
                        centerOffset: new Microsoft.Maps.Point(-70, 150),
                        zoom: 17
                    });
                    displayInfobox(pin);
                }
            });
            $('.viewprofile').click(function () {
                // Get the ID of the selected Provider
                var id = $(this).attr('rel');
                var windowOptions = {
                    openInNewWindow: true
                };
                Xrm.Utility.openEntityForm("account", id, null, windowOptions)               
            });
        }
             
        // Takes a pushpin and generates the content for the infobox from the Metadata and displays the infobox.
        function displayInfobox(pin) {

            var veteranLocation = $('#searchBox').val();

            infobox.setLocation(pin.getLocation());

            var desc = ['<table>'];

            desc.push('<tr><td colspan="2">', pin.Metadata.address1_line1, '<br/>', pin.Metadata.address1_city, ', ');
            desc.push(pin.Metadata.address1_city, '<br/>', pin.Metadata.address1_postalcode, '</td></tr>');
            desc.push('<tr><td><b>Hours:</b></td><td>',
                //pin.Metadata.hours,
                '</td></tr>');
            desc.push('<tr><td><b>Provider Specialty:</b></td><td>',
                pin.Metadata.specialty,
                //pin.Metadata.name,
                '</td></tr>');
            //desc.push('<tr><td colspan="2"><a target="_blank" href="https://bing.com/maps/default.aspx?rtp=~pos.', pin.Metadata.Latitude, '_', pin.Metadata.Longitude, '_', encodeURIComponent(pin.Metadata.ProviderName), '">Directions</a></td></tr>');
            desc.push('<tr><td colspan="2"><a target="_blank" href="https://bing.com/maps/default.aspx?rtp=adr.',
                veteranLocation,
                '~pos.',
                pin.Metadata.address1_latitude,
                '_',
                pin.Metadata.address1_longitude,
                '_',
                encodeURIComponent(pin.Metadata.name),
                '">Directions</a></td></tr>');
            desc.push('</table>');

            infobox.setOptions({ visible: true, title: pin.Metadata.name, description: desc.join('') });
        }       
    }
});